/*
 * Decompiled with CFR 0.152.
 */
package net.satisfyu.meadow.entity.blockentities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfyu.meadow.block.CheeseFormBlock;
import net.satisfyu.meadow.client.screen.handler.CheeseFormGuiHandler;
import net.satisfyu.meadow.recipes.cheese.CheeseFormRecipe;
import net.satisfyu.meadow.registry.BlockEntityRegistry;
import net.satisfyu.meadow.registry.ObjectRegistry;
import net.satisfyu.meadow.registry.RecipeRegistry;
import net.satisfyu.meadow.registry.TagRegistry;
import net.satisfyu.meadow.util.ImplementedInventory;
import org.jetbrains.annotations.Nullable;

public class CheeseFormBlockEntity
extends BlockEntity
implements BlockEntityTicker<CheeseFormBlockEntity>,
MenuProvider,
ImplementedInventory {
    private NonNullList<ItemStack> inventory;
    public static final int CAPACITY = 3;
    public static final int COOKING_TIME_IN_TICKS = 1800;
    private static final int OUTPUT_SLOT = 0;
    private int fermentationTime = 0;
    protected float experience;
    private final ContainerData propertyDelegate = new ContainerData(){

        public int m_6413_(int index) {
            if (index == 0) {
                return CheeseFormBlockEntity.this.fermentationTime;
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            if (index == 0) {
                CheeseFormBlockEntity.this.fermentationTime = value;
            }
        }

        public int m_6499_() {
            return 1;
        }
    };

    public CheeseFormBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.CHEESE_FORM_BLOCK_ENTITY.get(), pos, state);
        this.inventory = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        this.fermentationTime = nbt.m_128448_("fermentationTime");
        this.experience = nbt.m_128457_("experience");
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        nbt.m_128350_("experience", this.experience);
        nbt.m_128376_("fermentationTime", (short)this.fermentationTime);
    }

    public void tick(Level world, BlockPos pos, BlockState state, CheeseFormBlockEntity blockEntity) {
        boolean done;
        if (world.f_46443_) {
            return;
        }
        CheeseFormRecipe recipeType = world.m_7465_().m_44015_((RecipeType)RecipeRegistry.CHEESE.get(), (Container)blockEntity, world).orElse(null);
        boolean working = this.canCraft(recipeType);
        if (working) {
            ++this.fermentationTime;
            if (this.fermentationTime >= 1800) {
                this.fermentationTime = 0;
                this.craft(recipeType);
                this.m_6596_();
            }
        } else {
            this.fermentationTime = 0;
        }
        boolean bl = done = !((ItemStack)this.inventory.get(0)).m_41619_();
        if ((Boolean)state.m_61143_((Property)CheeseFormBlock.WORKING) != working || (Boolean)state.m_61143_((Property)CheeseFormBlock.DONE) != done) {
            world.m_46597_(pos, (BlockState)((BlockState)state.m_61124_((Property)CheeseFormBlock.WORKING, (Comparable)Boolean.valueOf(working))).m_61124_((Property)CheeseFormBlock.DONE, (Comparable)Boolean.valueOf(done)));
        }
    }

    private boolean canCraft(CheeseFormRecipe recipe) {
        if (recipe == null || recipe.m_8043_().m_41619_()) {
            return false;
        }
        if (this.areInputsEmpty()) {
            return false;
        }
        ItemStack itemStack = this.m_8020_(0);
        return itemStack.m_41619_() || itemStack == recipe.m_8043_();
    }

    private boolean areInputsEmpty() {
        int emptyStacks = 0;
        for (int i = 1; i <= 2; ++i) {
            if (!this.m_8020_(i).m_41619_()) continue;
            ++emptyStacks;
        }
        return emptyStacks == 2;
    }

    private void craft(CheeseFormRecipe recipe) {
        if (!this.canCraft(recipe)) {
            return;
        }
        ItemStack recipeOutput = recipe.m_8043_();
        ItemStack outputSlotStack = this.m_8020_(0);
        if (outputSlotStack.m_41619_()) {
            ItemStack output = recipeOutput.m_41777_();
            this.m_6836_(0, output);
        }
        for (Ingredient entry : recipe.m_7527_()) {
            ItemStack slot1Stack;
            if (entry.test(slot1Stack = this.m_8020_(1))) {
                if (slot1Stack.m_204117_(TagRegistry.MILK)) {
                    ItemStack bucket = slot1Stack.m_41720_() == ObjectRegistry.WOODEN_MILK_BUCKET.get() ? ((Item)ObjectRegistry.WOODEN_BUCKET.get()).m_7968_() : Items.f_42446_.m_7968_();
                    this.m_6836_(1, bucket);
                } else {
                    this.m_7407_(1, 1);
                }
            }
            ItemStack slot2Stack = this.m_8020_(2);
            if (!entry.test(this.m_8020_(2))) continue;
            if (slot2Stack.m_204117_(TagRegistry.MILK)) {
                ItemStack bucket = slot2Stack.m_41720_() == ObjectRegistry.WOODEN_MILK_BUCKET.get() ? ((Item)ObjectRegistry.WOODEN_BUCKET.get()).m_7968_() : Items.f_42446_.m_7968_();
                this.m_6836_(2, bucket);
                continue;
            }
            this.m_7407_(2, 1);
        }
    }

    @Override
    public int m_6643_() {
        return 3;
    }

    @Override
    public boolean m_7983_() {
        return this.inventory.stream().allMatch(ItemStack::m_41619_);
    }

    @Override
    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    @Override
    public ItemStack m_7407_(int slot, int amount) {
        return ContainerHelper.m_18969_(this.inventory, (int)slot, (int)amount);
    }

    @Override
    public ItemStack m_8016_(int slot) {
        return ContainerHelper.m_18966_(this.inventory, (int)slot);
    }

    @Override
    public void m_6836_(int slot, ItemStack stack) {
        ItemStack stackInSlot = (ItemStack)this.inventory.get(slot);
        boolean dirty = !stack.m_41619_() && stack.m_41656_(stackInSlot) && ItemStack.m_41658_((ItemStack)stack, (ItemStack)stackInSlot);
        this.inventory.set(slot, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        if (!(slot != 1 && slot != 2 || dirty)) {
            this.fermentationTime = 0;
            this.m_6596_();
        }
    }

    @Override
    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    @Override
    public void m_6211_() {
        this.inventory.clear();
    }

    public Component m_5446_() {
        return Component.m_130674_((String)"");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
        return new CheeseFormGuiHandler(syncId, inv, this, this.propertyDelegate);
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }
}

